/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.tests.comm;

import com.quantumdata.sct.comm.TEInterface;
import com.quantumdata.sct.comm.TEInterfaceConstants;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class QueryCommTest
extends TestCase {
    private TEInterface teinterface;
    private boolean bInitialize = false;

    public QueryCommTest(String string) {
        super(string);
    }

    protected void setUp() {
        try {
            this.bInitialize = true;
            this.teinterface = TEInterface.instance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.bInitialize = false;
        }
    }

    public void executeEmulateCommand() {
        QueryCommTest.assertEquals((boolean)this.bInitialize, (boolean)true);
        boolean bl = true;
        try {
            int n = this.teinterface.emulate(1, 2, 3, 4, 4, 30634, "DVD");
            System.out.println(this.teinterface.getLogicalAddress());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        QueryCommTest.assertEquals((boolean)bl, (boolean)true);
    }

    public void executeCECQuery() {
        QueryCommTest.assertEquals((boolean)this.bInitialize, (boolean)true);
        boolean bl = true;
        try {
            this.teinterface.setQuery("CECM?");
            String string = this.teinterface.sendMessageAndGetResponse();
            System.out.println(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        QueryCommTest.assertEquals((boolean)bl, (boolean)true);
    }

    public void executeScan() {
        QueryCommTest.assertEquals((boolean)this.bInitialize, (boolean)true);
        boolean bl = true;
        try {
            ArrayList arrayList = this.teinterface.scanInstrument();
            System.out.println(arrayList.toString());
        }
        catch (Exception exception) {
            bl = false;
        }
        QueryCommTest.assertEquals((boolean)bl, (boolean)true);
    }

    public void executeQuery() {
        QueryCommTest.assertEquals((boolean)this.bInitialize, (boolean)true);
        boolean bl = true;
        try {
            String string = this.teinterface.executeQueryWaitForResponse("*IDN?", TEInterfaceConstants.MAXATTEMPTS);
            System.out.println(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        QueryCommTest.assertEquals((boolean)bl, (boolean)true);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new QueryCommTest("executeQuery"));
        testSuite.addTest((Test)new QueryCommTest("executeCECQuery"));
        testSuite.addTest((Test)new QueryCommTest("executeEmulateCommand"));
        testSuite.addTest((Test)new QueryCommTest("scanInstrument"));
        return testSuite;
    }
}

